
#ifndef _1_CRYS_ATP_TST_C2_Acceptance_h_H
#define _1_CRYS_ATP_TST_C2_Acceptance_h_H

/*
 * All the include C2 that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_C2.h"
#include "CRYS_ATP_TST_Defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Dec 14 15:03:14 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief C2cription of this module
   *
   *  \version CRYS_ATP_TST_C2_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs  ****************************/
/************************ Structs  ******************************/
typedef struct TST_C2_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];	
	CRYS_C2_Key_t 				TST_Key;
	DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_Expected_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_dataSize;	
	CRYS_C2_OperationMode_t	TST_OperationMode;
} TST_C2_TestDataStruct;
			   
typedef struct TST_C2_HASH_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_input_dataSize;
	CRYS_C2HASH_Result_t        TST_HashResultBuff;
	CRYS_C2HASH_Result_t		TST_C2_Expected_output_data;
	DxUint16_t					TST_C2_Expected_dataSize;	
} TST_C2_HASH_TestDataStruct;

typedef struct TST_C2_OneWayFunc_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	CRYS_C2_Key_t 				TST_Key;
	DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_input_dataSize;
	DxUint8_t			        TST_ResultBuff[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t					TST_OneWayFunc_Expected_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	//DxUint16_t					TST_OneWayFunc_Expected_dataSize;	
} TST_C2_OneWayFunc_TestDataStruct;
/************************ Public Variables **********************/


/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_C2_Acceptance_NON_integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * C2cription:																	
 * 	This function Is a Acceptance test for C2 non integrated API's							
 * 	This function Encrypts and Decrypts known vectors using C2
 *  C2 moC2                   - CBC/ECB
 * 	Vector sizes used (in bytes) - 16/32/512/1536							
 * 	Key Size used (in bits)	    - 128/192/256								
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_C2_Init function to start the encryption/decryption process
 * 2. Call the CRYS_C2_Block - This function is called N times
 *                              (N = number of blocks in data)
 * 3. Call the CRYS_C2_Free to end the encryption/decryption process 
 * 4. Compare the outputted result to the expected one													
 *
 ******************************************************************************/
CRYSError_t CRYS_ATP_TST_C2_Acceptance_NON_integrated ( void );

/*****************************************************************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_C2_Acceptance_Integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * C2cription:																	
 * 	This function Is a Acceptance test for C2 integrated API							
 * 	This function Encrypts and Decrypts known vectors using C2
 *  C2 moC2                   - CBC/ECB
 * 	Vector sizes used (in bytes) - 16/32/512/1536							
 * 	Key Size used (in bits)	    - 128/192/256								
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_C2 function to use the C2 encryption/decryption process
 * 2. Compare the outputted result to the expected one													
 *
 ******************************************************************************/	
CRYSError_t CRYS_ATP_TST_C2_Acceptance_Integrated ( void );
 /*****************************************************************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_C2_HASH_Acceptance_NON_integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for HASH non integrated API's							
 * 	This function HASH known vectors using SHA1 and MD5
 * 	Vector sizes used (in bytes) - 16/32/512									
 * Algorithm:		
 * 1. Call the CRYS_HASH_Init function to start the encryption/decryption process
 * 2. Call the CRYS_HASH_Update - This function is called N times
 *                                (N = number of blocks in data each block is 16byte)
 * 3. Call the CRYS_HASH_Finish to end the HASH process and get the Digest result
 * 4. Compare the outputted result to the expected one													
 *
 ******************************************************************************/
CRYSError_t CRYS_ATP_TST_C2_HASH_Acceptance_NON_integrated ( void );
		    
/*****************************************************************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_C2_HASH_Acceptance_Integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for HASH integrated API							
 * 	This function HASH known vectors using SHA1 and MD5
 * 	Vector sizes used (in bytes) - 16/32/512/1536														
 * Algorithm:		
 * 1. Call the CRYS_HASH function to use the HASH process
 * 2. Compare the outputted result to the expected one													
 *
 ******************************************************************************/
CRYSError_t CRYS_ATP_TST_C2_HASH_Acceptance_Integrated ( void );
/*****************************************************************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_C2_HASH_Acceptance_Integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for HASH integrated API							
 * 	This function HASH known vectors using SHA1 and MD5
 * 	Vector sizes used (in bytes) - 16/32/512/1536														
 * Algorithm:		
 * 1. Call the CRYS_HASH function to use the HASH process
 * 2. Compare the outputted result to the expected one													
 *
 ******************************************************************************/
CRYSError_t CRYS_ATP_TST_C2_Acceptance_OneWayFunc( void );
CRYSError_t CRYS_ATP_TST_C2_Acceptance_ALL_TESTS(void);
             
#ifdef __cplusplus
}
#endif

#endif




